/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs;

import org.catacombae.hfs.BTreeOperations;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTKey;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BTreeFile {
    final HFSVolume vol;
    private final BTreeOperations ops;

    BTreeFile(HFSVolume vol, BTreeOperations ops) {
        this.vol = vol;
        this.ops = ops;
    }

    static <K extends CommonBTKey<K>> CommonBTIndexRecord<K> findLEKey(CommonBTIndexNode<K> indexNode, K searchKey) {
        CommonBTIndexRecord largestMatchingRecord = null;
        for (CommonBTIndexRecord record : indexNode.getBTRecords()) {
            Object recordKey = record.getKey();
            if (recordKey.compareTo(searchKey) > 0 || largestMatchingRecord != null && recordKey.compareTo(largestMatchingRecord.getKey()) <= 0) continue;
            largestMatchingRecord = record;
        }
        return largestMatchingRecord;
    }

    protected CommonBTHeaderNode createCommonBTHeaderNode(byte[] currentNodeData, int offset, int nodeSize) {
        return this.ops.createCommonBTHeaderNode(currentNodeData, offset, nodeSize);
    }

    protected CommonBTNodeDescriptor readNodeDescriptor(Readable rd) {
        return this.ops.readNodeDescriptor(rd);
    }

    protected CommonBTHeaderRecord readHeaderRecord(Readable rd) {
        return this.ops.readHeaderRecord(rd);
    }

    protected CommonBTNodeDescriptor createCommonBTNodeDescriptor(byte[] currentNodeData, int offset) {
        return this.ops.createCommonBTNodeDescriptor(currentNodeData, offset);
    }

    public HFSVolume getVolume() {
        return this.vol;
    }

    public abstract CommonBTNode getRootNode();

    public abstract long getRootNodeNumber();

    public abstract CommonBTNode getNode(long var1);

    abstract class BTreeFileSession {
        final CommonHFSVolumeHeader header;
        final CommonBTNodeDescriptor btnd;
        final CommonBTHeaderRecord bthr;
        final ReadableRandomAccessStream btreeStream;

        public BTreeFileSession() {
            this.header = BTreeFile.this.vol.getVolumeHeader();
            this.btreeStream = this.getBTreeStream(this.header);
            this.btreeStream.seek(0L);
            this.btnd = BTreeFile.this.readNodeDescriptor(this.btreeStream);
            if (this.btnd.getNodeType() != CommonBTNodeDescriptor.NodeType.HEADER) {
                throw new RuntimeIOException("Invalid node type for header node.");
            }
            this.bthr = BTreeFile.this.readHeaderRecord(this.btreeStream);
        }

        public final void close() {
            this.btreeStream.close();
        }

        protected abstract ReadableRandomAccessStream getBTreeStream(CommonHFSVolumeHeader var1);
    }
}

