/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs;

import org.catacombae.hfs.BTreeFile;
import org.catacombae.hfs.BTreeOperations;
import org.catacombae.hfs.io.ForkFilter;
import org.catacombae.hfs.plus.HFSPlusVolume;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSAttributesIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSAttributesLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.io.ReadableRandomAccessStream;

public class AttributesFile
extends BTreeFile {
    private final HFSPlusVolume view;

    public AttributesFile(HFSPlusVolume view, BTreeOperations ops) {
        super(view, ops);
        this.view = view;
    }

    private ReadableRandomAccessStream getAttributesFileStream(CommonHFSVolumeHeader.HFSPlusImplementation header) {
        return new ForkFilter(ForkFilter.ForkType.DATA, this.vol.getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID.ATTRIBUTES_FILE).toLong(), header.getAttributesFile(), this.vol.extentsOverflowFile, this.view.createFSStream(), 0L, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)this.view.getPhysicalBlockSize());
    }

    private Session openSession() {
        return new Session();
    }

    public long getRootNodeNumber() {
        Session ses = this.openSession();
        return ses.bthr.getRootNodeNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonBTNode getRootNode() {
        Session ses = this.openSession();
        try {
            long rootNode = ses.bthr.getRootNodeNumber();
            if (rootNode == 0L) {
                CommonBTNode commonBTNode = null;
                return commonBTNode;
            }
            if (rootNode < 0L || rootNode > 0xFFFFFFFEL) {
                throw new RuntimeException("Internal error - rootNode out of range: " + rootNode);
            }
            CommonBTNode commonBTNode = this.getNodeInternal(rootNode, ses);
            return commonBTNode;
        }
        finally {
            ses.close();
        }
    }

    public CommonBTHeaderNode getHeaderNode() {
        CommonBTNode firstNode = this.getNode(0L);
        if (firstNode instanceof CommonBTHeaderNode) {
            return (CommonBTHeaderNode)firstNode;
        }
        throw new RuntimeException("Unexpected node type at catalog node 0: " + firstNode.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonBTNode getNode(long nodeNumber) {
        if (nodeNumber < 0L) {
            throw new IllegalArgumentException("Invalid node number: " + nodeNumber);
        }
        Session ses = this.openSession();
        try {
            CommonBTNode commonBTNode = this.getNodeInternal(nodeNumber, ses);
            return commonBTNode;
        }
        finally {
            ses.close();
        }
    }

    private CommonBTNode getNodeInternal(long nodeNumber, Session ses) {
        String METHOD = "getNodeInternal";
        int nodeSize = ses.bthr.getNodeSize();
        byte[] nodeData = new byte[nodeSize];
        try {
            ses.btreeStream.seek(nodeNumber * (long)nodeSize);
            ses.btreeStream.readFully(nodeData);
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException in getNodeInternal. Printing additional information:");
            System.err.println("  nodeNumber=" + nodeNumber);
            System.err.println("  nodeSize=" + nodeSize);
            System.err.println("  init.btreeStream.length()=" + ses.btreeStream.length());
            System.err.println("  (currentNodeNumber * nodeSize)=" + nodeNumber * (long)nodeSize);
            throw e;
        }
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(nodeData, 0);
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.HEADER) {
            return this.createCommonBTHeaderNode(nodeData, 0, nodeSize);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            return CommonHFSAttributesIndexNode.createHFSPlus(nodeData, 0, nodeSize);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            return CommonHFSAttributesLeafNode.createHFSPlus(nodeData, 0, nodeSize);
        }
        return null;
    }

    private class Session
    extends BTreeFile.BTreeFileSession {
        ReadableRandomAccessStream attributesFileStream;

        private Session() {
            super(AttributesFile.this);
        }

        protected ReadableRandomAccessStream getBTreeStream(CommonHFSVolumeHeader header) {
            if (!(header instanceof CommonHFSVolumeHeader.HFSPlusImplementation)) {
                throw new RuntimeException("Illegal CommonHFSVolumeHeader flavour (expected HFSPlusImplementation, got " + header.getClass() + ").");
            }
            if (this.attributesFileStream == null) {
                this.attributesFileStream = AttributesFile.this.getAttributesFileStream((CommonHFSVolumeHeader.HFSPlusImplementation)header);
            }
            return this.attributesFileStream;
        }
    }
}

