/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs;

import java.util.LinkedList;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.util.ObjectContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AllocationFile {
    protected final HFSVolume parentView;
    protected final ReadableRandomAccessStream allocationFileStream;

    protected AllocationFile(HFSVolume parentView, ReadableRandomAccessStream allocationFileStream) {
        this.parentView = parentView;
        this.allocationFileStream = allocationFileStream;
        if (this.parentView == null) {
            throw new IllegalArgumentException("parentView == null");
        }
    }

    public synchronized boolean isAllocationBlockUsed(long blockNumber) throws IllegalArgumentException {
        CommonHFSVolumeHeader vh = this.parentView.getVolumeHeader();
        return this.isAllocationBlockUsed(blockNumber, vh);
    }

    private synchronized boolean isAllocationBlockUsed(long blockNumber, CommonHFSVolumeHeader vh) {
        long numAllocationBlocks = vh.getTotalBlocks();
        if (blockNumber >= numAllocationBlocks) {
            throw new IllegalArgumentException("Block number (" + blockNumber + ") is beyond the highest block of the volume (" + (numAllocationBlocks - 1L) + ").");
        }
        long byteIndex = blockNumber / 8L;
        this.allocationFileStream.seek(byteIndex);
        int currentByte = this.allocationFileStream.read();
        if (currentByte >= 0) {
            return (currentByte & 1 << (int)(7L - blockNumber % 8L)) != 0;
        }
        throw new RuntimeException("No data left in stream! allocationFileStream.getFilePointer()=" + this.allocationFileStream.getFilePointer() + " allocationFileStream.length()=" + this.allocationFileStream.length());
    }

    public long countBlocks(ObjectContainer<Long> oFreeBlocks, ObjectContainer<Long> oUsedBlocks, ObjectContainer<Boolean> stop) {
        CommonHFSVolumeHeader vh = this.parentView.getVolumeHeader();
        byte[] currentBlock = new byte[131072];
        long totalBlocks = vh.getTotalBlocks();
        long blockCount = 0L;
        long usedBlockCount = 0L;
        if (stop == null) {
            stop = new ObjectContainer<Boolean>(false);
        }
        this.allocationFileStream.seek(0L);
        while (blockCount < totalBlocks && !((Boolean)stop.o).booleanValue()) {
            int bytesRead = this.allocationFileStream.read(currentBlock);
            if (bytesRead >= 0) {
                for (int i = 0; i < bytesRead && blockCount < totalBlocks && !((Boolean)stop.o).booleanValue(); ++i) {
                    byte currentByte = currentBlock[i];
                    for (int j = 0; j < 8 && blockCount < totalBlocks && !((Boolean)stop.o).booleanValue(); ++j) {
                        ++blockCount;
                        if ((currentByte >> 7 - j & 1) != 1) continue;
                        ++usedBlockCount;
                    }
                }
                continue;
            }
            throw new RuntimeException("Could not read all blocks from allocation file!");
        }
        if (blockCount != totalBlocks) {
            throw new RuntimeException("[INTERNAL ERROR] blockCount(" + blockCount + ") != totalBlocks(" + totalBlocks + ")");
        }
        if (oFreeBlocks != null) {
            oFreeBlocks.o = blockCount - usedBlockCount;
        }
        if (oUsedBlocks != null) {
            oUsedBlocks.o = usedBlockCount;
        }
        return totalBlocks;
    }

    protected abstract CommonHFSExtentDescriptor createExtentDescriptor(long var1, long var3) throws IllegalArgumentException;

    public synchronized CommonHFSExtentDescriptor[] findFreeSpace(long fileSize) {
        long blocksToAllocate;
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Negative file size: " + fileSize);
        }
        CommonHFSVolumeHeader vh = this.parentView.getVolumeHeader();
        long blockSize = vh.getAllocationBlockSize();
        long totalBlocks = vh.getTotalBlocks();
        long blocksLeft = blocksToAllocate = fileSize / blockSize + (long)(fileSize % blockSize != 0L ? 1 : 0);
        ByteRegion closestMatchAbove = new ByteRegion();
        ByteRegion closestMatchBelow = new ByteRegion();
        LinkedList<ByteRegion> allocations = new LinkedList<ByteRegion>();
        while (blocksLeft > 0L) {
            if (closestMatchAbove == null) {
                closestMatchAbove = new ByteRegion();
            }
            if (closestMatchBelow == null) {
                closestMatchBelow = new ByteRegion();
            }
            closestMatchAbove.reset();
            closestMatchBelow.reset();
            long regionStart = -1L;
            int i = 0;
            while ((long)i < totalBlocks) {
                int j = 0;
                for (ByteRegion br : allocations) {
                    if ((long)i >= br.offset && (long)i < br.offset + br.length) break;
                    ++j;
                }
                if (j == allocations.size()) {
                    if (!this.isAllocationBlockUsed(i, vh)) {
                        if (regionStart == -1L) {
                            regionStart = i;
                        }
                    } else {
                        if (regionStart != -1L) {
                            long length = (long)i - regionStart;
                            if (length > blocksLeft) {
                                if (closestMatchAbove.length < 0L || closestMatchAbove.length > length) {
                                    closestMatchAbove.offset = regionStart;
                                    closestMatchAbove.length = length;
                                }
                            } else if (length < blocksLeft) {
                                if (closestMatchBelow.length < 0L || closestMatchBelow.length < length) {
                                    closestMatchBelow.offset = regionStart;
                                    closestMatchBelow.length = length;
                                }
                            } else {
                                closestMatchAbove.offset = regionStart;
                                closestMatchAbove.length = length;
                                break;
                            }
                        }
                        regionStart = -1L;
                    }
                }
                ++i;
            }
            if (closestMatchAbove.isValid()) {
                closestMatchAbove.length = blocksLeft;
                allocations.add(closestMatchAbove);
                blocksLeft = 0L;
                closestMatchAbove = null;
                continue;
            }
            if (closestMatchBelow.isValid()) {
                allocations.add(closestMatchBelow);
                blocksLeft -= closestMatchBelow.length;
                closestMatchBelow = null;
                continue;
            }
            return null;
        }
        if (blocksLeft != 0L) {
            throw new RuntimeException("[INTERNAL ERROR] blocksLeft(" + blocksLeft + ") != 0 [closestMatchAbove.offset=" + closestMatchAbove.offset + ",closestMatchAbove.length=" + closestMatchAbove.length + "]");
        }
        CommonHFSExtentDescriptor[] result = new CommonHFSExtentDescriptor[allocations.size()];
        int i = 0;
        for (ByteRegion br : allocations) {
            result[i++] = this.createExtentDescriptor(br.offset, br.length);
        }
        return result;
    }

    public void close() {
        this.allocationFileStream.close();
    }

    private class ByteRegion {
        public long offset;
        public long length;

        private ByteRegion() {
        }

        public void reset() {
            this.offset = -1L;
            this.length = -1L;
        }

        public boolean isValid() {
            return this.offset > 0L && this.length > 0L;
        }
    }
}

