/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.csjc.structelements;

import java.lang.reflect.Field;
import org.catacombae.csjc.structelements.DataHandle;
import org.catacombae.util.Util;

class IntegerFieldDataHandle
implements DataHandle {
    private final Field field;
    private final Object object;
    private final int length;

    public IntegerFieldDataHandle(Object object, Field field, int length) {
        switch (length) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length: " + length);
            }
        }
        this.object = object;
        this.field = field;
        this.length = length;
    }

    public byte[] getBytesAsCopy() {
        try {
            byte[] res;
            switch (this.length) {
                case 1: {
                    res = Util.toByteArrayBE(this.field.getByte(this.object));
                    break;
                }
                case 2: {
                    res = Util.toByteArrayBE(this.field.getShort(this.object));
                    break;
                }
                case 4: {
                    res = Util.toByteArrayBE(this.field.getInt(this.object));
                    break;
                }
                case 8: {
                    res = Util.toByteArrayBE(this.field.getLong(this.object));
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            return res;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Illegal access while trying to read field: [" + this.field, e);
        }
    }

    public byte[] getBytesAsCopy(int offset, int length) {
        return Util.createCopy(this.getBytesAsCopy(), offset, length);
    }

    public int getLength() {
        return this.length;
    }
}

