/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.csjc.structelements;

import java.lang.reflect.Field;
import java.math.BigInteger;
import org.catacombae.csjc.structelements.ByteArrayDataHandle;
import org.catacombae.csjc.structelements.DataHandle;
import org.catacombae.csjc.structelements.Endianness;
import org.catacombae.csjc.structelements.FieldType;
import org.catacombae.csjc.structelements.IntegerFieldBits;
import org.catacombae.csjc.structelements.IntegerFieldDataHandle;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.csjc.structelements.Signedness;
import org.catacombae.csjc.structelements.StringRepresentableField;
import org.catacombae.util.Util;

public class IntegerField
extends StringRepresentableField {
    private final DataHandle fieldData;
    private final int offset;
    private final IntegerFieldBits bits;
    private final Signedness signedness;
    private final Endianness endianness;
    private final BigInteger maxValue;
    private final BigInteger minValue;
    private final IntegerFieldRepresentation representation;

    public IntegerField(byte[] fieldData, IntegerFieldBits bits, Signedness signedness, Endianness endianness) {
        this(fieldData, 0, bits, signedness, endianness);
    }

    public IntegerField(byte[] fieldData, int offset, IntegerFieldBits bits, Signedness signedness, Endianness endianness) {
        this(fieldData, offset, bits, signedness, endianness, IntegerFieldRepresentation.DECIMAL, null);
    }

    public IntegerField(byte[] fieldData, int offset, IntegerFieldBits bits, Signedness signedness, Endianness endianness, IntegerFieldRepresentation representation, String unitComponent) {
        this(new ByteArrayDataHandle(fieldData), offset, bits, signedness, endianness, representation, unitComponent);
    }

    public IntegerField(Object obj, Field fieldData, int offset, IntegerFieldBits bits, Signedness signedness, Endianness endianness, IntegerFieldRepresentation representation, String unitComponent) {
        this(new IntegerFieldDataHandle(obj, fieldData, bits.getBytes()), offset, bits, signedness, endianness, representation, unitComponent);
    }

    public IntegerField(DataHandle fieldData, int offset, IntegerFieldBits bits, Signedness signedness, Endianness endianness, IntegerFieldRepresentation representation, String unitComponent) {
        super((signedness == Signedness.SIGNED ? "S" : "U") + "Int" + bits.getBits(), FieldType.INTEGER, unitComponent);
        if (fieldData == null) {
            throw new IllegalArgumentException("fieldData == null");
        }
        if (bits == null) {
            throw new IllegalArgumentException("bits == null");
        }
        if (signedness == null) {
            throw new IllegalArgumentException("signedness == null");
        }
        if (endianness == null) {
            throw new IllegalArgumentException("endianness == null");
        }
        if (representation == null) {
            throw new IllegalArgumentException("representation == null");
        }
        if (fieldData.getLength() - offset < bits.getBytes()) {
            throw new IllegalArgumentException("Not enough data left in fieldData!");
        }
        this.fieldData = fieldData;
        this.offset = offset;
        this.bits = bits;
        this.signedness = signedness;
        this.endianness = endianness;
        this.representation = representation;
        byte[] maxValueBytes = new byte[bits.getBytes()];
        byte[] minValueBytes = new byte[bits.getBytes()];
        Util.set(maxValueBytes, (byte)-1);
        Util.zero(new byte[][]{minValueBytes});
        if (signedness == Signedness.SIGNED) {
            maxValueBytes[0] = (byte)(maxValueBytes[0] & 0x7F);
            minValueBytes[0] = -128;
        }
        this.maxValue = new BigInteger(1, maxValueBytes);
        this.minValue = new BigInteger(minValueBytes);
        String validateMsg = this.validateData();
        if (validateMsg != null) {
            throw new IllegalArgumentException("Invalid value passed to constructor! Message: " + validateMsg);
        }
    }

    private String validateData() {
        return this.validate(this.getValueAsBigInteger());
    }

    private String validate(BigInteger bi) {
        if (this.signedness != Signedness.SIGNED && bi.signum() == -1) {
            return "Tried to insert negative value into unsigned field.";
        }
        if (bi.compareTo(this.maxValue) > 0) {
            return "Value too large for field! Maximum value is " + this.maxValue.toString() + ".";
        }
        if (bi.compareTo(this.minValue) < 0) {
            return "Value too small for this field. Minimum value is " + this.minValue.toString() + ".";
        }
        return null;
    }

    public BigInteger getValueAsBigInteger() {
        byte[] data;
        if (this.endianness == Endianness.LITTLE_ENDIAN) {
            data = Util.byteSwap(this.fieldData.getBytesAsCopy(this.offset, this.bits.getBytes()));
        } else if (this.endianness == Endianness.BIG_ENDIAN) {
            data = this.fieldData.getBytesAsCopy(this.offset, this.bits.getBytes());
        } else {
            throw new RuntimeException("Illegal endianness value: " + (Object)((Object)this.endianness));
        }
        if (this.signedness == Signedness.SIGNED) {
            return new BigInteger(data);
        }
        if (this.signedness == Signedness.UNSIGNED) {
            return new BigInteger(1, data);
        }
        throw new RuntimeException("Illegal signedness value: " + (Object)((Object)this.signedness));
    }

    public String getValueAsString() {
        return this.representation.getPrefix() + this.getValueAsBigInteger().toString(this.representation.getRadix());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStringValue(String value) throws IllegalArgumentException {
        byte[] trueContents;
        String validateMsg = this.validateStringValue(value);
        if (validateMsg != null) throw new IllegalArgumentException("Invalid string value! Message: " + validateMsg);
        BigInteger bi = new BigInteger(value);
        byte[] ba = bi.toByteArray();
        if (this.signedness == Signedness.SIGNED && ba.length != this.bits.getBytes()) {
            throw new RuntimeException("UNEXPECTED: ba.length (" + ba.length + ") != bits.getBytes()(" + this.bits.getBytes() + ")");
        }
        if (this.signedness == Signedness.UNSIGNED && ba.length != this.bits.getBytes() + 1) {
            throw new RuntimeException("UNEXPECTED: ba.length (" + ba.length + ") != bits.getBytes()+1(" + this.bits.getBytes() + "+1=" + (this.bits.getBytes() + 1) + ")");
        }
        if (this.endianness == Endianness.LITTLE_ENDIAN) {
            trueContents = Util.createReverseCopy(ba, ba.length - this.bits.getBytes(), this.bits.getBytes());
        } else {
            if (this.endianness != Endianness.BIG_ENDIAN) throw new RuntimeException("Illegal endianness value: " + (Object)((Object)this.endianness));
            trueContents = Util.createCopy(ba, ba.length - this.bits.getBytes(), this.bits.getBytes());
        }
        System.arraycopy(trueContents, 0, this.fieldData, this.offset, this.bits.getBytes());
    }

    public String validateStringValue(String s) {
        try {
            BigInteger bi = new BigInteger(s);
            return this.validate(bi);
        }
        catch (NumberFormatException nfe) {
            return "Invalid integer string.";
        }
    }
}

