//
//  NSAffineTransform+CRKit.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 3/4/13.
//
//

@interface NSAffineTransform (CRKit)

- (void)rotateByRadians:(CGFloat)angle aroundCenter:(NSPoint)center;
- (void)rotateByDegrees:(CGFloat)angle aroundCenter:(NSPoint)center;

+ (NSAffineTransform *)rotationTransformWithDegrees:(CGFloat)angle aroundCenter:(NSPoint)center;
+ (NSAffineTransform *)rotationTransformWithRadians:(CGFloat)angle aroundCenter:(NSPoint)center;

- (void)scaleBy:(CGFloat)scale origin:(NSPoint)origin;
- (void)scaleXBy:(CGFloat)scaleX yBy:(CGFloat)scaleY origin:(NSPoint)origin;
+ (NSAffineTransform *)scalingTransformWithScale:(CGFloat)scale origin:(NSPoint)origin;
+ (NSAffineTransform *)scalingTransformWithScaleXBy:(CGFloat)scaleX yBy:(CGFloat)scaleY origin:(NSPoint)origin;

@end