//
//  CRView.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 10/19/09.
//  Copyright 2009 Corner-A. All rights reserved.
//


//////////////////////////////////////////////////////////////////////
// CRView
//////////////////////////////////////////////////////////////////////
@interface CRView : NSView
{
}

@property (assign, readwrite) id<CRViewDelegate> delegate;

- (BOOL)subview:(NSView *)theView mouseUp:(NSEvent *)theEvent;
- (BOOL)subview:(NSView *)theView mouseDown:(NSEvent *)theEvent;
- (BOOL)subview:(NSView *)theView mouseDragged:(NSEvent *)theEvent;
- (BOOL)subview:(NSView *)theView mouseEntered:(NSEvent *)theEvent;
- (BOOL)subview:(NSView *)theView mouseExited:(NSEvent *)theEvent;

- (NSDragOperation)subview:(NSView *)theView draggingEntered:(id<NSDraggingInfo>)sender;
- (NSDragOperation)subview:(NSView *)theView draggingUpdated:(id<NSDraggingInfo>)sender;
- (BOOL)subview:(NSView *)theView prepareForDragOperation:(id<NSDraggingInfo>)sender;
- (BOOL)subview:(NSView *)theView performDragOperation:(id<NSDraggingInfo>)sender;
- (void)subview:(NSView *)theView draggingExited:(id<NSDraggingInfo>)sender;
- (void)subview:(NSView *)theView concludeDragOperation:(id<NSDraggingInfo>)sender;
- (void)subview:(NSView *)theView draggingEnded:(id<NSDraggingInfo>)sender;

@end