//
//  CRUndoObserver.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 4/16/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Does all Undo registration job:
// Register for id<CRUndoable> root object and all it's sub-items
// recursevily
//////////////////////////////////////////////////////////////////////
@interface CRUndoObserver : NSObject
{
	id				root;
	NSUndoManager*	undoManager;
	CRUndoProxy*	undoProxy;
	NSMutableArray* subObservers;
}

@property (nonatomic, weak) NSUndoManager* undoManager;

- (id)initWithRootUndoable:(id)aRoot undoManager:(NSUndoManager *)aManager;

@end