//
//  CRTextFields.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 04/07/10.
//  Copyright 2010 Corner-A. All rights reserved.
//


//////////////////////////////////////////////////////////////////////
// Shadowed text field
//////////////////////////////////////////////////////////////////////
@interface CRTextFieldShadowed : NSTextField
{
	NSMutableDictionary* attributes;
}

@property (nonatomic, strong) NSColor* shadowColor;

@end

//////////////////////////////////////////////////////////////////////
// Beveled text field
//////////////////////////////////////////////////////////////////////
@interface CRTextFieldBeveled : NSTextField
{
}

@end

//////////////////////////////////////////////////////////////////////
// Beveled (manual) text field
//////////////////////////////////////////////////////////////////////
@interface CRTextFieldBeveledShadow : CRTextFieldShadowed
{
}

@end

//////////////////////////////////////////////////////////////////////
// CRDoubleClickTextField
//////////////////////////////////////////////////////////////////////
@interface CRDoubleClickTextField : NSTextField
{
	NSString*				savedText;
	NSMutableDictionary*	attributes;
}

@property (nonatomic, assign) id		delegate;
@property (nonatomic, strong) NSColor*	shadowColor;

- (IBAction)startEdit:(id)sender;
- (IBAction)endEdit:(id)sender;

@end

//////////////////////////////////////////////////////////////////////
// CRDoubleClickTextField
//////////////////////////////////////////////////////////////////////
@interface CRDoubleClickTextFieldBeveled : CRDoubleClickTextField
{
}

@end