//
//  CRStoryboardController.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 2/8/12.
//  Copyright (c) 2012 Sladki Programi d.o.o. All rights reserved.
//

@class CRStoryboardViewController;

//////////////////////////////////////////////////////////////////////
// Whole Storyboard controller
//////////////////////////////////////////////////////////////////////
@interface CRStoryboardController : NSResponder
{
	NSArray*					story;
	NSMutableDictionary*		storyData;
	CRStoryboardViewController* currentPage;
	BOOL						closeAfterLastPage;
	
@private
	NSView*						controlPlace;
}

// Properties
@property (strong) NSArray*						story;
@property (strong) NSMutableDictionary*			storyData;

@property (assign) CRStoryboardViewController*	currentPage;
@property (assign) BOOL							closeAfterLastPage;

// Outlets
@property (assign) IBOutlet id					root;
@property (assign) IBOutlet NSView*				storyPlace;

// Methods
- (void)buildPages;
- (void)connect;
- (void)disconnect;
- (void)deactivatePage:(CRStoryboardViewController *)page;
- (void)activatePage:(CRStoryboardViewController *)page;

// Actions
- (void)goToStep:(int)index;
- (void)goForwardSteps:(int)steps;
- (IBAction)goBackward:(id)sender;
- (IBAction)goForward:(id)sender;
- (IBAction)closeStory:(id)sender;

- (void)adjustUI;
- (void)requestPageSize:(NSSize)size animate:(BOOL)animate;
- (void)requestPageSize:(NSSize)size;
- (void)reset;

@end