//
//  CRSlider.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 04/07/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRControl.h"

//////////////////////////////////////////////////////////////////////
// CRSliderCaret
//////////////////////////////////////////////////////////////////////
@interface CRSliderCaret : CRView
{
	BOOL isEnabled;
	BOOL isPressed;
	BOOL didSignal;
}

@property (assign, readwrite) BOOL isEnabled;

@end

//////////////////////////////////////////////////////////////////////
// CRSlider
//////////////////////////////////////////////////////////////////////
@interface CRSlider : CRControl
{
@private
	BOOL ignoreSlidersMovements;
	
@protected
	BOOL isEnabled;
	BOOL doUndoGrouping;
	NSMutableArray* values;
	NSArray* valuesMin;
	NSArray* valuesMax;
}

@property (assign, readwrite) BOOL isEnabled;
@property (assign, readwrite) BOOL doUndoGrouping;
@property (copy,   readwrite) NSArray* values;
@property (strong, readwrite) NSArray* valuesMin;
@property (strong, readwrite) NSArray* valuesMax;

- (CGFloat)value;						// reads first value
- (void)setValue:(CGFloat)aValue;		// writes first value
- (CGFloat)valueMin;					// reads first value min constraint
- (void)setValueMin:(CGFloat)aValue;	// writes first value min constraint
- (CGFloat)valueMax;					// reads first value max constraint
- (void)setValueMax:(CGFloat)aValue;	// writes first value max constraint

- (void)prepareForChanges:(id)sender;
- (void)finalizeChanges:(id)sender;

@end