//
//  CRNSSegmentedControlBase.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 9/21/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// CRAlternateImageData
//////////////////////////////////////////////////////////////////////
@interface CRAlternateImageData : NSObject

@property (strong) NSImage* image;
@property (assign) NSInteger segment;

@end

//////////////////////////////////////////////////////////////////////
// CRNSSegmentedCellBase
//////////////////////////////////////////////////////////////////////
@interface CRNSSegmentedCellBase : NSSegmentedCell
{
	CGFloat xAlign;
	NSMutableArray* alternateImages;
}

- (NSColor *)interiorColor;
- (void)drawImage:(NSImage *)image inRect:(NSRect)rect alpha:(CGFloat)alpha;

- (NSImage *)alternateImageForSegment:(NSInteger)segment;
- (void)setAlternateImage:(NSImage *)image forSegment:(NSInteger)segment;

- (NSMutableDictionary *)textAttributes;

@end

//////////////////////////////////////////////////////////////////////
// CRNSSegmentedControlBase
//////////////////////////////////////////////////////////////////////
@interface CRNSSegmentedControlBase : NSSegmentedControl
{
}

@end