//
//  CRModeMatrix.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 1/30/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRView.h"
#import "CRControl.h"

//////////////////////////////////////////////////////////////////////
// Mode matrix switch
//////////////////////////////////////////////////////////////////////
@interface CRModeMatrixSwitch : CRView
{
	BOOL isPressed;
}

@end

//////////////////////////////////////////////////////////////////////
// Mode matrix mode
//////////////////////////////////////////////////////////////////////
@interface CRModeMatrixMode : NSTextField
{
	NSPoint dotPoint;
}

@property (assign, readwrite) NSPoint dotPoint;

@end

//////////////////////////////////////////////////////////////////////
// Mode matrix
//////////////////////////////////////////////////////////////////////
@interface CRModeMatrix : CRControl
{	
@protected
	NSArray*		modes;			// available modes
	NSUInteger		selectedMode;	// selected mode
	int				rowHeight;		// mode representation height
	
	NSRect			prArea;			//
	NSBezierPath*	countour;		// visual countour
	NSMutableArray* modeControls;	//
	
	NSView*			slider;			// switch slider
}

@property (strong, readwrite) NSArray*		modes;
@property (assign, readwrite) NSUInteger	selectedMode;
@property (assign, readwrite) int			rowHeight;

- (void)sliderToPoint:(NSPoint)position canJump:(BOOL)canJump;
- (void)sliderToClosestWithPoint:(NSPoint)position;

@end