//
//  CRLibraryManager.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 10/19/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRLibraryController.h"


//////////////////////////////////////////////////////////////////////
// CRLibraryManager
//////////////////////////////////////////////////////////////////////
@interface CRLibraryManager : NSObject
{
	NSString* assigned				name;							// library name (reserved)
	BOOL							libraryIsLoaded;				// signal whether library is loaded
	BOOL							ignoreSignals;					// disables KVo notifications
	BOOL							loadingSystems;					// signals whether the system items are loaded
	
@private
	NSMutableArray*					availableItems;					// available library items in planar list
	NSDictionary*					allTags;						// full tags set for the library, keys are the tags, values are usage count
	NSMutableDictionary*			libraryStore;					// library items in dictionary store
}

@property (nonatomic, assign)						id				delegate;			// up
@property (unsafe_unretained, nonatomic, readonly)	NSString*		name;				// up
@property (nonatomic, strong)						NSArray*		ignoredCategories;	// up
@property (unsafe_unretained, nonatomic, readonly)	NSArray*		availableItems;		// up
@property (unsafe_unretained, nonatomic, readonly)	NSDictionary*	libraryStore;		// up
@property (unsafe_unretained, nonatomic, readonly)	NSDictionary*	allTags;			// depended property, cashed for performance purposes
@property (unsafe_unretained, nonatomic, readonly)	NSArray*		categories;			// depended property

- (NSArray *)itemExtensions;

- (id<CRLibraryItem>)loadItemFromFile:(NSString *)filePath;
- (NSString *)pathForItem:(id<CRLibraryItem>)item;
- (void)removeItem:(id<CRLibraryItem>)item toTrash:(BOOL)bTrashCan;
- (void)renameItem:(id<CRLibraryItem>)item newName:(NSString *)newName;
- (void)flushItem:(id<CRLibraryItem>)item;
- (id<CRLibraryItem>)saveItem:(id<CRLibraryItem>)item;
- (id<CRLibraryItem>)collisionForItem:(id<CRLibraryItem>)item;
- (id<CRLibraryItem>)collisionForItem:(id<CRLibraryItem>)item withNewName:(NSString *)name;
- (id<CRLibraryItem>)collisionForItemName:(NSString *)itemName category:(NSString *)itemCategory;

- (NSString *)libraryPath;
- (NSString *)systemLibraryPath;

- (BOOL)libraryItemIsDeprecated:(NSString *)oldFile systemSet:(NSArray *)oldSystemFiles bundleSet:(NSArray *)systemFiles;

@end