//
//  CRLibraryController.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 6/16/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

@class CRLibraryManager;
@class CRScrollView;

extern NSString* const CRLibraryControllerViewItemKey;

//////////////////////////////////////////////////////////////////////
// Library controller
//////////////////////////////////////////////////////////////////////
@interface CRLibraryController : NSResponder<CRLibraryControllerProtocol, NSCollectionViewDelegate>
{
}

// Properties
@property (nonatomic, strong)			CRLibraryManager*	library;
@property (nonatomic, strong)			id					editingItem;
@property (unsafe_unretained, readonly) NSWindow*			window;

// Outlets
@property (nonatomic, assign) IBOutlet NSView*				rootView;
@property (nonatomic, assign) IBOutlet NSWindow*			rootWindow;
@property (nonatomic, assign) IBOutlet NSArrayController*	itemsController;
@property (nonatomic, assign) IBOutlet NSCollectionView*	itemsCollection;
@property (nonatomic, assign) IBOutlet CRScrollView*		scroller;
@property (nonatomic, assign) IBOutlet NSPanel*				itemPanel;

// Items management
- (IBAction)addItem:(id)sender;
- (IBAction)removeSelected:(id)sender;
- (void)addOrReplaceItem:(id)item;

- (IBAction)confirmAddItem:(id)sender;
- (IBAction)cancelAddItem:(id)sender;
- (void)sheetForItem:(id)item params:(NSDictionary *)params;

// Library-specific
- (void)fillPanelWithItem:(id)item params:(NSDictionary *)params;
- (id)itemWithPanel:(id)item;
- (id)defaultItem;
- (NSString *)confirmDeleteQuestion;

// Browser
- (void)activateBrowser;
- (void)deactivateBrowser;
- (void)cleanupBrowser;

@end