//
//  Constants.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 3/3/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

// Constants
#import "CRConstants.h"

// Protocols
#import "CRProtocols.h"

// Common auxilliary pack
#import "CRAssigner.h"
#import "CRUndoProxy.h"
#import "CRUndoObserver.h"
#import "CRMathHelpers.h"
#import "CRAuxilliary.h"
#import "CRCommonDraw.h"
#import "CRTemporaryFilesManager.h"
#import "CRRandomGenerator.h"
#import "CRSharedTimer.h"

// Reflection
#import "CRReflection.h"

// Categories
#import "NSImage+CRKit.h"
#import "NSSortDescriptor+CRKit.h"
#import "NSDate+CRKit.h"
#import "NSBezierPath+CRKit.h"
#import "NSApplication+CRKit.h"
#import "NSString+CRKit.h"
#import "NSWindow+CRKit.h"
#import "NSView+CRKit.h"
#import "NSFileManager+CRKit.h"
#import "NSAffineTransform+CRKit.h"

// Transformers
#import "CRTransformersHelpers.h"
#import "CIColorToNSColorTransformer.h"
#import "NSNumberMultiplyTransformer.h"
#import "CGRectToCIVectorTransformer.h"
#import "CRAngleToVectorTransformer.h"
#import "NSArrayToStringTransformer.h"
#import "NSPathToFilenameTransformer.h"
#import "CRRectToStringTransformer.h"
#import "CRFileNameToPureNameTransformer.h"

// Binding
#import "CRTwoWayBindingManager.h"

// Custom
#import "CRParameterDescriptor.h"
#import "CRMultiDelegate.h"

// Animation
#import "CRAnimationKey.h"
#import "CRAnimationStack.h"

// Storyboard
#import "CRStoryboardController.h"
#import "CRStoryboardViewController.h"
#import "CRStoryboardWindowController.h"
#import "CRStoryboardSheetController.h"

// Controls: Common
#import "CRControlDrawing.h"

#import "CRView.h"
#import "CRDraggableView.h"
#import "CRControl.h"
#import "CRNSControl.h"
#import "CRTextFields.h"
#import "CRSlider.h"
#import "CRComplexSlider.h"
#import "CRNSSlider.h"
#import "CRNSSliderTextured.h"
#import "CRNSSliderTransparent.h"
#import "CRModeMatrix.h"
#import "CRImageView.h"
#import "CRScrollView.h"
#import "CRNSScrollViewTransparent.h"
#import "CROverlayScrollView.h"
#import "CRTableView.h"
#import "ImageAndTextCell.h"
#import "CRPathEditor.h"
#import "CRProgressIndicator.h"
#import "CRPopUpButtonTextured.h"
#import "CRButtonImaged.h"
#import "CRNSPopUpButtonTransparent.h"
#import "CRNSSegmentedControlTransparent.h"
#import "CRNSButtonTextured.h"
#import "CRNSCheckboxTextured.h"
#import "CRNSSegmentedControlTextured.h"
#import "CRRoundedBox.h"
#import "CROptionalBox.h"
#import "CRNSButtonLight.h"
#import "CRNSPopUpButtonLight.h"
#import "CRNSSegmentedControlLight.h"
#import "CRNSOptionalBoxLight.h"
#import "CRLevelIndicator.h"
#import "CRCustomBox.h"
#import "CRShadowBackView.h"
#import "CRThemeView.h"
#import "CRUISwitcher.h"
#import "CRUISwitcherCI.h"
#import "CRRoundedBoxTextured.h"
#import "CRRoundedBoxTexturedOptional.h"

// Controls: NS-Collections
#import "CRCollectionView.h"
#import "CRCollectionImageView.h"
#import "CRCollectionTextField.h"
#import "CRImageCollectionItemView.h"

// Controls: CR-Collections
#import "CRItemsCollectionView.h"
#import "CRItemsCollectionScrollableView.h"
#import "CRGroupedItemsCollectionView.h"

#import "CRCollectionViewBaseLayouts.h"
#import "CRCollectionViewLayoutChain.h"
#import "CRCollectionViewLayoutList.h"
#import "CRCollectionViewLayoutMatrix.h"
#import "CRCollectionViewLayoutStack.h"

// Controls: Stacks
#import "CRStackingPanel.h"
#import "CRLayersStackingItemView.h"
#import "CRStackingItemController.h"
#import "CRStackingItemHostController.h"
#import "CRComplexStackingItemController.h"

// Controls: Windows
#import "CRTransparentWindow.h"
#import "CRBubblePanel.h"
#import "CRDocumentWindow.h"
#import "CRToolHUDPanel.h"
#import "CRCustomThemeWindow.h"
#import "CRAttachablePanel.h"
#import "CRToolPanel.h"

// Controllers
#import "CRAttachedWindowController.h"	// uses MAAttachedWindow by Matt Gemmell, open MAAttachedWindow.h/mm for comments
#import "CRReflectedViewController.h"
#import "CRAboutWindowController.h"
#import "CRWelcomeWindowController.h"
#import "CSImageSaveOptions.h"

// Library
#import "CRItemsManager.h"
#import "CRLibraryManager.h"
#import "CRLibraryController.h"
#import "CRLibraryViewController.h"
#import "CRLibraryWindowController.h"

// Registration
void CRKitInitialize();
void CRKitCleanup();