//
//  ItemsChainView.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 10/16/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRItemsCollectionView.h"

extern NSString* const CRGroupedItemsCollectionViewGroupPboardType;

//////////////////////////////////////////////////////////////////////
// CRCollectionViewGroupDescription
//////////////////////////////////////////////////////////////////////
@interface CRCollectionViewGroupDescriptor : NSObject<NSCoding>
{
@private
	NSString* name;
	NSRange range;
	BOOL expanded;
}

@property (strong, readonly)  NSString* name;
@property (assign, readwrite) NSRange range;
@property (assign, readonly)  NSUInteger count;
@property (assign, readwrite) BOOL expanded;

- (id)initWithName:(NSString*)aName range:(NSRange)aRange;
+ (CRCollectionViewGroupDescriptor*)groupWithName:(NSString*)aName range:(NSRange)aRange;

- (void)addLength;

@end

//////////////////////////////////////////////////////////////////////
// CRGroupedItemsCollectionGroupHeaderView
//////////////////////////////////////////////////////////////////////
@interface CRGroupedItemsCollectionGroupHeaderView : CRCollectionViewItemBase
{
}

@end

//////////////////////////////////////////////////////////////////////
// CRGroupedItemsCollectionGroupHeaderViewController
//////////////////////////////////////////////////////////////////////
@interface CRGroupedItemsCollectionGroupHeaderViewController : NSViewController
{
}

@property (assign) id owner;

@end

//////////////////////////////////////////////////////////////////////
// CRGroupedItemsCollectionViewGroupPlaceholderView
//////////////////////////////////////////////////////////////////////
@interface CRGroupedItemsCollectionViewGroupPlaceholderView : NSView
{
}

@end

//////////////////////////////////////////////////////////////////////
// CRItemsCollectionMatrixView
// Inherites CRItemsCollectionView and makes it possible to bind to
// NSDictionaryController where keys are treated as group names and
// values as groups content (NSArray)
//////////////////////////////////////////////////////////////////////
@interface CRGroupedItemsCollectionView : CRItemsCollectionView
{
@protected
	BOOL			contentIsPlanar;						// signals whether content is array with categories property
	NSView*			groupPlaceholderView;					// group placeholder view
	NSString*		userDefaultsStoreForGroupsDescriptors;	// NSUserDefualts key to store groups tate
	NSMutableArray* groupsControllers;						// group controllers
}

@property (copy, readwrite)		NSString* userDefaultsStoreForGroupsDescriptors;
@property (assign, readwrite)	BOOL contentIsPlanar;

- (void)loadGroupsState;
- (void)saveGroupsState;

@end