//
//  CRComplexStackingItemController.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 1/10/11.
//  Copyright 2011 Corner-A. All rights reserved.
//

#import "CRStackingItemController.h"

//////////////////////////////////////////////////////////////////////
// Entry view controller
//////////////////////////////////////////////////////////////////////
@interface CRComplexStackingItemController : CRStackingItemController
{	
	NSMutableArray*	content;
	NSMutableArray*	contentHeaders;
}

// Properties
@property (unsafe_unretained, nonatomic, readonly) NSMutableArray* content;		// either NSView or NSViewController instances
@property (unsafe_unretained, nonatomic, readonly) NSMutableArray* contentHeaders;	// either NSView or NSViewController instances

// Outlets
@property (nonatomic, assign) IBOutlet CRView* headerView;

// Methods
- (void)loadItems;
- (NSView *)viewForItem:(id)contentItem;

@end