//
//	CRAuixilliary.h
//	CRKit
//
//	Created by Yaroslav Glushchenko on 3/11/10.
//	Copyright 2010 Corner-A. All rights reserved.
//
//

//////////////////////////////////////////////////////////////////////
// Auxilliary
//////////////////////////////////////////////////////////////////////
NS_INLINE SInt32 GetMacOSVersion()
{
	OSStatus status;
	SInt32  response;
	
	status = Gestalt(gestaltSystemVersion, &response);
	if (status != noErr)
		response = 0;
	
	return response;	
}

//////////////////////////////////////////////////////////////////////
// Anchors
//////////////////////////////////////////////////////////////////////
enum CRAnchor
{
	AnchorNone		= 0x00,
	
	AnchorXLeft		= 0x01,
	AnchorXCenter	= 0x02,
	AnchorXRight	= 0x04,
	
	AnchorYBottom	= 0x10,
	AnchorYCenter	= 0x20,
	AnchorYTop		= 0x40,
	
	AnchorXMask		= 0x0F,
	AnchorYMask		= 0xF0,
	
	AnchorLeftBottom = AnchorXLeft | AnchorYBottom,
	AnchorLeft = AnchorXLeft | AnchorYCenter,
	AnchorLeftTop = AnchorXLeft | AnchorYTop,
	AnchorTop = AnchorXCenter | AnchorYTop,
	AnchorMiddle = AnchorXCenter | AnchorYCenter,
	AnchorBottom = AnchorXCenter | AnchorYBottom,
	AnchorRightBottom = AnchorXRight | AnchorYBottom,
	AnchorRight = AnchorXRight | AnchorYCenter,
	AnchorRightTop = AnchorXRight | AnchorYTop
};

NS_INLINE NSPoint CRGetOffset(NSPoint fromPoint, NSPoint toPoint)
{
	return NSMakePoint(toPoint.x - fromPoint.x, toPoint.y - fromPoint.y);
}

NS_INLINE NSPoint NSLeftBottom(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMinX(rect), NSMinY(rect));
}

NS_INLINE NSPoint NSBottom(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMidX(rect) - objectSize.width / 2, NSMinY(rect));
}

NS_INLINE NSPoint NSRightBottom(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMaxX(rect) - objectSize.width, NSMinY(rect));
}

NS_INLINE NSPoint NSLeft(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMinX(rect), NSMidY(rect) - objectSize.height / 2);
}

NS_INLINE NSPoint NSMiddle(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMidX(rect) - objectSize.width / 2, NSMidY(rect) - objectSize.height / 2);
}

NS_INLINE NSPoint NSRight(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMaxX(rect) - objectSize.width, NSMidY(rect) - objectSize.height / 2);
}

NS_INLINE NSPoint NSLeftTop(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMinX(rect), NSMaxY(rect) - objectSize.height);
}

NS_INLINE NSPoint NSTop(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMidX(rect) - objectSize.width / 2, NSMaxY(rect) - objectSize.height);
}

NS_INLINE NSPoint NSRightTop(NSRect rect, NSSize objectSize = NSZeroSize)
{
	return NSMakePoint(NSMaxX(rect) - objectSize.width, NSMaxY(rect) - objectSize.height);
}

NS_INLINE NSPoint CRAnchorForRect(NSRect rect, CRAnchor anchor, NSSize objectSize = NSZeroSize)
{
	switch ((int)anchor)
	{
		case AnchorLeftBottom:  return NSLeftBottom(rect, objectSize);
		case AnchorLeft:		return NSLeft(rect, objectSize);
		case AnchorLeftTop:		return NSLeftTop(rect, objectSize);
		case AnchorTop:			return NSTop(rect, objectSize);
		case AnchorMiddle:		return NSMiddle(rect, objectSize);
		case AnchorBottom:		return NSBottom(rect, objectSize);
		case AnchorRightBottom:	return NSRightBottom(rect, objectSize);
		case AnchorRight:		return NSRight(rect, objectSize);
		case AnchorRightTop:	return NSRightTop(rect, objectSize);
	}
	
	return NSZeroPoint;
}

//////////////////////////////////////////////////////////////////////
// Type converters
//////////////////////////////////////////////////////////////////////
id			CIVectorWithCGRect(CGRect rect);
CGRect		CGRectWithCIVector(id vector);
NSArray*	NSArrayWithCGRect(CGRect rect);
NSArray*	NSArrayWithCIVector(id vector);