//
//  CRAttachablePanel.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 7/2/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

extern NSString* const CRAttachedToPanelKey;
extern NSString* const CRAttachedPanelKey;
extern NSString* const CRPanelFrameKey;

@class CRAttachmentLock;

//////////////////////////////////////////////////////////////////////
// Attachable panel can be attached to or contain an attached panel
//////////////////////////////////////////////////////////////////////
@interface CRAttachablePanel : NSPanel<CRViewDelegate, NSWindowDelegate>
{
	BOOL				noRecursion;
	BOOL				isSynchronizing;
	BOOL				isUpdating;
	
@protected
	CRAttachablePanel*	attachedPanel;
	BOOL				isMoving;
	BOOL				customAttach;
	NSSize				minAutoAttachDistance;
	NSString*			attachmentUsingName;
	
	CRAttachmentLock* assigned topLock;
	CRAttachmentLock* assigned bottomLock;
}

@property (nonatomic, unsafe_unretained) CRAttachablePanel* attachedPanel;

// auto-attachment
@property (nonatomic, assign)	BOOL customAttach;
@property (nonatomic, assign)	NSSize minAutoAttachDistance;
@property (nonatomic, copy)		NSString* attachmentUsingName;
@property (unsafe_unretained, nonatomic, readonly) CRAttachmentLock* topLock;
@property (unsafe_unretained, nonatomic, readonly) CRAttachmentLock* bottomLock;

// methods
- (void)initialize;

@end