//
//  CRAssigner.h
//  UITestPlace
//
//  Created by Yaroslav Glushchenko on 5/21/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Copies data from one object to another. Be careful, it uses
// NSCoding and it's full your responsibility for the copy process
//
// NOTE:
// Destination:initWithCoder: is called, so this class must be
// used during the initialization!
//////////////////////////////////////////////////////////////////////
@interface CRAssigner : NSObject
{
}

+ (id)copyObject:(id<NSCoding>)source;
+ (id)copyObject:(id<NSCoding>)source asClass:(Class)destinationClass;
+ (void)readItemData:(id<NSCoding>)destination fromObject:(id<NSCoding>)source;
+ (void)readItemData:(id<NSCoding>)destination fromObject:(id<NSCoding>)source posing:(Class)sourceClass asClass:(Class)destinationClass;

@end