//
//  CRAnimationKey.h
//  Lingoo
//
//  Created by Yaroslav Glushchenko on 7/14/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRAnimationStack;

//////////////////////////////////////////////////////////////////////
// Stack key
//////////////////////////////////////////////////////////////////////
@interface CRAnimationKey : NSObject
{
	CRAnimationStack* assigned	root;
	NSTimeInterval				duration;
}

@property (unsafe_unretained, readonly) CRAnimationStack*	root;
@property (readonly) NSTimeInterval		duration;

- (id)initWithRoot:(CRAnimationStack *)aRoot duration:(NSTimeInterval)aDuration;

- (void)run;

@end

//////////////////////////////////////////////////////////////////////
// Stack key for CoreAnimation invocation
//////////////////////////////////////////////////////////////////////
@interface CRCAAnimationKey : CRAnimationKey
{
}

@property (assign)	id			target;
@property (strong)	id			value;
@property (strong)	id			value2;
@property (copy)	NSString*	key;
@property (assign)	SEL			action;

@end

//////////////////////////////////////////////////////////////////////
// Stack key for NSAnimation invocation
//////////////////////////////////////////////////////////////////////
@interface CRNSAnimationKey : CRAnimationKey<NSAnimationDelegate>
{
	NSAnimation* animation;
}

@property (strong) NSAnimation*	animation;

@end