//
//  CRTextureAdapter.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/6/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

extern NSString* const CRTextureAdapterDoTileKey;
extern NSString* const CRTextureAdapterRelativeCoordKey;
extern NSString* const CRTextureAdapterKeepAspectKey;
extern NSString* const CRTextureAdapterAspectExtendKey;
extern NSString* const CRTextureAdapterBaseRectKey;
extern NSString* const CRTextureAdapterRotationAngleKey;
extern NSString* const CRTextureAdapterCropRectKey;
extern NSString* const CRTextureAdapterAutoImageKey;
extern NSString* const CRTextureAdapterAutoFlagsKey;

//////////////////////////////////////////////////////////////////////
// Takes an input CIImage and returns new one transformed with
// few rules. It stores all internal data in native simple manner and
// provides number of wrappers for binding,
// 
// COMMENT:
// NSCoding support does not encode images!
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRAdapterAutoNone	= 0x0,	// no flags at all
	
	CRAdapterAutoOrigin = 0x01,	// when set, origin is taken form the autoImage
	CRAdapterAutoSize	= 0x02, // when set, size is taken from	the autoImage
	CRAdapterAutoAngle	= 0x04,	// when set, angle is 0 for non-nil autoImage
	CRAdapterAutoCrop	= 0x08, // when set, crop is autoImage.extent for non-nil autoImage
	CRAdapterAutoTile	= 0x10, // when set, tile is turned off for non-nil autoImage
	CRAdapterAutoImage	= 0x20,	// when set, inputImage is autoImage
	
	CRAdapterAutoRect	= CRAdapterAutoOrigin | CRAdapterAutoSize,
	CRAdapterAutoAll	= 0x3F,	// all above
} CRAdapterAutoFlags;

@interface CRTextureAdapter : CRImageProcessor
{
}

@property (nonatomic, assign) BOOL			doTile;			// signals whether output texture should be tiled
@property (nonatomic, assign) BOOL			relativeCoord;	// signals whether baseRect sets relative rect
@property (nonatomic, assign) BOOL			keepAspect;		// signals whether inputImage aspect must be kept during transform
@property (nonatomic, assign) BOOL			aspectExtend;	// signals whether the image must be stretched UP or DOWN toget into the aspect
@property (nonatomic, assign) CGRect		baseRect;		// output texture base rect
@property (nonatomic, assign) CGFloat		rotationAngle;	// output texture rotation

@property (nonatomic, copy)   CIVector*		cropRect;		// optional, nil by default. crops output image
@property (nonatomic, copy)	  CIImage*		autoImage;		// optional, nil by default. Adapter will adjust all params with this image: baseRect, cropRect etc.
@property (nonatomic, assign) NSInteger		autoFlags;		// autoFlags

// wrappers for binding support
@property (nonatomic, assign) CGFloat		baseOriginX;
@property (nonatomic, assign) CGFloat		baseOriginY;
@property (nonatomic, assign) CGFloat		baseWidth;
@property (nonatomic, assign) CGFloat		baseHeight;

+ (CRTextureAdapter *)adapter;

// Specials
- (CGRect)textureSpaceRect;

@end