//
//  CRTexture.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/19/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRCIImageManager.h"

//////////////////////////////////////////////////////////////////////
// Texture
//////////////////////////////////////////////////////////////////////
@interface CRTexture : CRLibraryItemBase<CRDraggable>
{
	NSString*	filePath;
	
	CIImage*	image;
	NSSize		requestedSize;
}

@property (nonatomic, copy)		NSString*	filePath;
@property (nonatomic, readonly)	CIImage*	image;
@property (nonatomic, readonly) BOOL		isLoaded;
@property (nonatomic, readonly) BOOL		isVectorized;

- (id)initWithFilePath:(NSString *)aPath;

// Common
+ (id)texture;
+ (id)textureWithFilePath:(NSString *)aPath;

// Requests
- (void)setRequestedSize:(NSSize)size;

// Draggable
+ (NSArray *)supportedDragTypes;
+ (void)writeObjects:(NSArray *)objects toPasteboard:(NSPasteboard *)pboard;
+ (BOOL)pasteboardContainsObjects:(NSPasteboard *)pboard;
+ (NSArray *)objectsFromPasteboard:(NSPasteboard *)pboard;

@end