//
//  CRSharedRenderer.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 11/23/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// A single buffer
//////////////////////////////////////////////////////////////////////
@interface CRRendererBuffer : NSObject
{
	NSImage*	buffer;
	NSSize		bufferSize;
	BOOL		locked;
	BOOL		justCreated;
}

@property (readonly) BOOL locked;

- (id)initWithSize:(NSSize)size;
+ (id)bufferWithSize:(NSSize)size;

@end

//////////////////////////////////////////////////////////////////////
// This aux class initialize some bitmap buffer and graphics context
// to be used by a bunch of objects during some queued tasks like
// presets previews rendering
//////////////////////////////////////////////////////////////////////
@interface CRSharedRenderer : NSObject
{
	BOOL			dropWhenRendered;
	NSMutableArray* buffers;
}

- (id)initWithSize:(NSSize)maximumSize count:(int)count;
+ (id)rendererWithSize:(NSSize)maximumSize count:(int)count;

- (NSImage *)render:(CIImage *)image;
- (NSImage *)render:(CIImage *)image colorSpace:(NSString *)colorSpaceName;

@end