//
//  CRShadowGenerator.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/1/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

extern NSString* const CRShadowGeneratorFastKey;
extern NSString* const CRShadowGeneratorQualityKey;
extern NSString* const CRShadowGeneratorBlurRadiusKey;
extern NSString* const CRShadowGeneratorAngleKey;
extern NSString* const CRShadowGeneratorOffsetKey;
extern NSString* const CRShadowGeneratorColorKey;
extern NSString* const CRShadowGeneratorScaleKey;

//////////////////////////////////////////////////////////////////////
// Shadow generator
//////////////////////////////////////////////////////////////////////
@interface CRShadowGenerator : CRImageProcessor
{
}

@property (nonatomic, assign) BOOL		shadowFast;			// toggles Box/Gaussian blur
@property (nonatomic, assign) CGFloat	shadowQuality;
@property (nonatomic, assign) CGFloat	shadowBlurRadius;
@property (nonatomic, assign) CGFloat	shadowAngle;
@property (nonatomic, assign) CGFloat	shadowOffset;
@property (nonatomic, copy)	  CIColor*	shadowColor;

+ (CRShadowGenerator *)shadow;

@end