//
//  CRSceneItemWrapperPort.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 10/25/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRSceneItemPort.h"

//////////////////////////////////////////////////////////////////////
// Scene item port that wraps some keyPath of the root object
//
// NOTE:
// Wrapper port DOESN'T observe target keyPath. KVO in this case will
// cause huge problems with NKVODeallocateBreak
//////////////////////////////////////////////////////////////////////
@interface CRSceneItemWrapperPort : CRSceneItemPort
{
	id	assigned			root;
	CRParameterDescriptor*	parameter;
}

@property (nonatomic, readonly, assign) id						root;
@property (nonatomic, readonly)			CRParameterDescriptor*	parameter;

- (id)initWithName:(NSString *)portName type:(NSUInteger)portType root:(id)object parameter:(CRParameterDescriptor *)portParameter codingTransformer:(NSString *)transformerName;
+ (id)portWithName:(NSString *)portName type:(NSUInteger)portType root:(id)object parameter:(CRParameterDescriptor *)portParameter codingTransformer:(NSString *)transformerName;

@end