//
//  CRSceneItemPortsAuxiliary.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 10/25/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#ifndef _PORTS_AUX_

//////////////////////////////////////////////////////////////////////
// Ports
//////////////////////////////////////////////////////////////////////
namespace ports_auxiliary {

struct adapter
{
	id idValue;
	
	inline operator id()
	{
		return idValue;
	}
	
	inline explicit adapter(int value)
		: idValue([NSNumber numberWithInt:value])
	{}
	
	inline explicit adapter(CGFloat value)
		: idValue([NSNumber numberWithDouble:(double)value])
	{}
	
	inline explicit adapter(BOOL value)
		: idValue([NSNumber numberWithBool:value])
	{}
	
	inline explicit adapter(NSRect value)
		: idValue([NSValue valueWithRect:value])
	{}
	
	inline explicit adapter(NSPoint value)
	: idValue([NSValue valueWithPoint:value])
	{}
	
	inline explicit adapter(id value)
		: idValue(value)
	{}
};

};

//////////////////////////////////////////////////////////////////////
// Auxiliary
//////////////////////////////////////////////////////////////////////
#define CRDefineWrapperPort(p, u, t, n) {\
	id port = [[CRSceneItemWrapperPort alloc] initWithName:n type:t root:self parameter:[CRParameterDescriptor descriptorWithKeyPath:p usage:u] codingTransformer:nil];\
	[ports addPort:port];\
	[port release];\
}

#define CRDefineWrapperPortEx(p, u, t, n, ct) {\
	id port = [[CRSceneItemWrapperPort alloc] initWithName:n type:t root:self parameter:[CRParameterDescriptor descriptorWithKeyPath:p usage:u] codingTransformer:ct];\
	[ports addPort:port];\
	[port release];\
}

#define CRDefineValuePort(n, u, t, v) {\
	id port = [[CRSceneItemValuePort alloc] initWithName:n type:t usage:u defaultValue:(id)ports_auxiliary::adapter(v) codingTransformer:nil];\
	[ports addPort:port];\
	[port release];\
}

#define CRDefineValuePortEx(n, u, t, v, ct) {\
	id port = [[CRSceneItemValuePort alloc] initWithName:n type:t usage:u defaultValue:(id)ports_auxiliary::adapter(v) codingTransformer:ct];\
	[ports addPort:port];\
	[port release];\
}

#define CRPortPathUI(n) [NSString stringWithFormat:@"representedObject.ports.%@.value", n]

//////////////////////////////////////////////////////////////////////
// Auxiliary
//////////////////////////////////////////////////////////////////////
#define CRDefineWrapperPortARC(n, u, t, p) {\
	id port = [[CRSceneItemWrapperPort alloc] initWithName:n type:t root:self parameter:[CRParameterDescriptor descriptorWithKeyPath:p usage:u] codingTransformer:nil];\
	[ports addPort:port];\
}

#define CRDefineWrapperPortExARC(n, u, t, p, ct) {\
	id port = [[CRSceneItemWrapperPort alloc] initWithName:n type:t root:self parameter:[CRParameterDescriptor descriptorWithKeyPath:p usage:u] codingTransformer:ct];\
	[ports addPort:port];\
}

#define CRDefineValuePortARC(n, u, t, v) {\
	id port = [[CRSceneItemValuePort alloc] initWithName:n type:t usage:u defaultValue:(id)ports_auxiliary::adapter(v) codingTransformer:nil];\
	[ports addPort:port];\
}

#define CRDefineValuePortExARC(n, u, t, v, ct) {\
	id port = [[CRSceneItemValuePort alloc] initWithName:n type:t usage:u defaultValue:(id)ports_auxiliary::adapter(v) codingTransformer:ct];\
	[ports addPort:port];\
}

#endif