//
//  CRSceneBase.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/12/12.
//  Copyright (c) 2012 Sladki Programi d.o.o. All rights reserved.
//

#import "CRSceneItemVisual.h"

extern NSString* const CRSceneGraphItemsKey;

//////////////////////////////////////////////////////////////////////
// Scene base
//////////////////////////////////////////////////////////////////////
@interface CRSceneBase : CRSceneItemVisual
{
	id assigned				sceneRoot;		// a root object or nil
	NSString*				colorSpace;		// working color space
	id assigned				undoProvider;	// automatic undo support: undo manager provider
	CRUndoObserver*			undoManager;	// CRGraphics undo manager
	NSArray*				graphItems;		// graph items
}

// Properties
@property (nonatomic, assign)	id			sceneRoot;
@property (nonatomic, copy)		NSString*	colorSpace;
@property (nonatomic, assign)	id			undoProvider;
@property (nonatomic, strong)	NSArray*	graphItems;		// graph items
@property (nonatomic, assign)	NSArray*	graphWithScene;	// a wrapper, self + graph items, to be used in complex scene UI

// Items management
- (void)addItem:(CRSceneItemVisual *)item;
- (void)addItems:(NSArray *)items;
- (void)removeItem:(CRSceneItemVisual *)item;
- (void)removeAllItems;

// Undo
- (void)rebuildUndoControllers;

@end