//
//  CRPresetsLibraryController.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/13/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRPreset.h"
#import "CRPresetsLibraryManager.h"

@class CRImageData;

extern NSString* const CRPresetsThumbnailsSize;

//////////////////////////////////////////////////////////////////////
// Presets preview
//////////////////////////////////////////////////////////////////////
@interface CRPresetsLibraryController : CRLibraryController
{
	CRImageData*	photoData;
	CRPreset*		savingPreset;	// non-retained preset reference
	
	NSToolbarItem*	toolbarLoadImage;
	NSToolbarItem*	toolbarNewPreset;
	NSToolbarItem*	toolbarEditPreset;
	
@protected
	BOOL			editMode;
	BOOL			alwaysRequestOverwriteConfirmation;
	CGFloat			currentThumbnailsAspect;
}

// Outlets
@property (nonatomic, assign)	IBOutlet NSSegmentedControl*	presetsControl;
@property (nonatomic, assign)	IBOutlet NSSlider*				presetsSizeSlider;
@property (nonatomic, assign)	IBOutlet NSWindow*				presetRegistrationSheet;
@property (nonatomic, assign)	IBOutlet NSTextField*			presetName;
@property (nonatomic, assign)	IBOutlet NSTokenField*			presetTags;

// Properties
@property (nonatomic, retain)	CRImageData*					photoData;			// photo data
@property (nonatomic, readonly)	CRPreset*						selectedPreset;		// preset selected in the browser
- (CRPresetsLibraryManager* )									library;			// override trick to 'fix' return type

- (NSString *)photoPath;
- (void)setPhotoPath:(NSString *)photoPath;

// Auxilliary
- (CRPreset *)selectedPreset; // is not KVO compilant
- (void)collectionView:(NSCollectionView *)collectionView caughtFiles:(NSArray *)files;

// Actions
- (IBAction)changeThumbnailsSize:(id)sender;
- (IBAction)exportPreset:(id)sender;
- (IBAction)importPreset:(id)sender;

// Presets management
- (BOOL)editPreset:(CRPreset *)preset rootWindow:(NSWindow *)sheetRoot;
- (BOOL)savePreset:(CRPreset *)preset rootWindow:(NSWindow *)sheetRoot overwriteRequest:(BOOL)request;
- (void)exportPreset:(CRPreset *)preset rootWindow:(NSWindow *)sheetRoot;
- (BOOL)importPresetForRootWindow:(NSWindow *)sheetRoot overwriteRequest:(BOOL)request;

@end