//
//  CRPresetsCollectionView.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 10/19/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

@class CRCollectionTextField;
@class CRPresetsCollectionItem;
@class CRSharedRenderer;

//////////////////////////////////////////////////////////////////////
// Templates collection view
//////////////////////////////////////////////////////////////////////
@interface CRPresetsCollectionView : NSCollectionView
{
@protected
	NSMutableArray*		internalItems;
	
@private
	NSColor*			backgroundPattern;
	NSImage*			dropNoteImage;
	NSImage*			filterNoteImage;
	CIImage*			previewSource;
	BOOL				previewDirty;
	CRSharedRenderer*	sharedRenderer;
	NSOperationQueue*	queuePreviews;
}

@property (nonatomic, assign) id delegate;
@property (nonatomic, assign) IBOutlet NSArrayController* contentController;

- (CRPresetsCollectionItem *)itemForObject:(id)object;
- (void)setPreviewSource:(CIImage *)source;
- (void)dropPreviews;
- (void)cleanQueue:(BOOL)cleanRenderer;

@end