//
//  CRPhotoViewScrollable.h
//  CRGrapgics
//
//  Created by Yaroslav Glushchenko on 04/04/10
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRPhotoViewBase.h"

//////////////////////////////////////////////////////
// CRPhotoViewScrollable, a CRPhotoView analog made to
// be used in ScrollView-less mode
//////////////////////////////////////////////////////
@interface CRPhotoViewScrollable : CRPhotoViewBase 
{
@protected
	id			sourceImage;
	NSPoint		scrollPoint;
	CGFloat		zoom;
	BOOL		drawBorder;
	
	NSRect		imageRect;
	NSRect		portionRect;
	NSRect		adoptedPortionRect;
	NSRect		photoArea;
	
	NSPoint		draggingFrom;
	NSView*		editorHost;			// this intermediate view is something like NSClipView for the in-place editors
}

@property (nonatomic, assign) id			delegate;			// delegate, intended to be the CRPhotoViewController
@property (nonatomic, strong) id			sourceImage;		// source image
@property (nonatomic, assign) NSPoint		scrollPoint;		// visible area scroll point
@property (nonatomic, assign) CGFloat		zoom;				// zoom value
@property (nonatomic, assign) BOOL			drawBorder;

@property (nonatomic, readonly) NSRect		imageRect;
@property (nonatomic, readonly) NSRect		portionRect;
@property (nonatomic, readonly) NSRect		adoptedPortionRect;
@property (nonatomic, readonly) NSRect		photoArea;

- (NSSize)spacing;
- (NSRect)fullArea;
- (void)updateRects;
- (void)updateView;

- (CIContext *)coreContext;

@end