//
//  CRMipMapper.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/22/10.
//  Copyright 2010 Corner-A. All rights reserved.
//


//////////////////////////////////////////////////////////////////////
// Mip-map level
//////////////////////////////////////////////////////////////////////
@interface CRMipMap : NSObject
{
	CGFloat  scale;
	CIImage* image;
}

@property (readonly) CIImage*	image;
@property (readonly) CGFloat	scale;

- (id)initWithSource:(CIImage*)source andScale:(CGFloat)totalScale;
+ (id)mipMapWithSource:(CIImage*)source andScale:(CGFloat)totalScale;

@end


//////////////////////////////////////////////////////////////////////
// Mip-map maker
//////////////////////////////////////////////////////////////////////
@interface CRMipMapper : NSObject
{
	CGFloat		minimumMapSize;
	CGFloat		mapDownstep;
	
	BOOL		smartMode;
	BOOL		canSwitch;
	
	CRMipMap*	selectedMap;
	CIImage*	inputImage;
	CIImage*	outputImage;
	CGFloat		scale;
	NSArray*	mipMaps;
}

@property (nonatomic, strong)	CIImage*	inputImage;
@property (nonatomic, strong)	CIImage*	outputImage;
@property (nonatomic, assign)	BOOL		smartMode;		// when turned on, mapper will switch maps with scale. else it will puhs inputImage through
@property (nonatomic, assign)	BOOL		canSwitch;		// when turned on, mapper is allowed to switch maps, else it returns last selected
@property (nonatomic, assign)	CGFloat		scale;			// approximate scale value, mapper will set up closest mip-map
@property (nonatomic, readonly)	CGFloat		exactScale;		// exact scale value from the original input image to the mip-map
@property (nonatomic, readonly)	NSArray*	mipMaps;

- (void)fetchMipMaps:(CRMipMapper *)mapper;
- (id)initWithMinimumMaxSize:(CGFloat)minimumSize downStep:(CGFloat)step;

@end