//
//  CRMaterialProcessor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/8/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRMaterial.h"

@class CRShaderBase;

extern NSString* const CRMaterialProcessorShaderKey;
extern NSString* const CRMaterialProcessorSelfShadeKey;
extern NSString* const CRMaterialProcessorShaderMaterialKey;
extern NSString* const CRMaterialProcessorSourceMaterialKey;
extern NSString* const CRMaterialProcessorSourceImageKey;

//////////////////////////////////////////////////////////////////////
// Material-processor. This can either generate a sample or process an
// area:
// - Shader
// - Bump-mapping
// - Glass (and other distortions)
//////////////////////////////////////////////////////////////////////
@interface CRMaterialProcessor : CRMaterial
{
	CRMaterial*		sourceMaterial;	// sourceMaterial. Uses either it or sourceImage (second object is dropped)
	CIImage*		sourceImage;	// sourceImage. Uses either it or sourceMaterial (second object is dropped)
	CRMaterial*		shaderMaterial;	// shaderMaterial
	
	CRShaderBase*	shader;
	
@protected
	BOOL			canToggleSelfShade;
}

@property (nonatomic, strong) CRMaterial*	sourceMaterial;
@property (nonatomic, strong) CIImage*		sourceImage;
@property (nonatomic, strong) CRMaterial*	shaderMaterial;

@property (nonatomic, strong) CRShaderBase*	shader;
@property (nonatomic, assign) BOOL			selfShade;

@property (nonatomic, assign) BOOL			canToggleSelfShade;

@end