//
//  CRMaterialPath.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/11/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRMaterialGenerator.h"
#import "CRPathHolder.h"

extern NSString* const CRMaterialPathPathKey;
extern NSString* const CRMaterialPathTensionKey;
extern NSString* const CRMaterialPathInternalColorKey;
extern NSString* const CRMaterialPathExternalColorKey;

//////////////////////////////////////////////////////////////////////
// Path-based material
//////////////////////////////////////////////////////////////////////
@interface CRMaterialPath : CRMaterialGenerator
{
	CRPathHolder*		pathHolder;
	NSBitmapImageRep*	buffer;
}

@property (nonatomic, strong)	CRPathHolder*	pathHolder;
@property (nonatomic, copy)		NSColor*		internalColor;
@property (nonatomic, copy)		NSColor*		externalColor;

@end