//
//  CRItemsAtPlain.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/31/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

extern NSString* const CRItemsAtPlainItemsKey;
extern NSString* const CRItemsAtPlainDropShadowsKey;
extern NSString* const CRItemsAtPlainLayersKey;
extern NSString* const CRItemsAtPlainItemsScaleKey;
extern NSString* const CRItemsAtPlainDisperionKey;
extern NSString* const CRItemsAtPlainSpaceLeftKey;
extern NSString* const CRItemsAtPlainSpaceTopKey;
extern NSString* const CRItemsAtPlainSpaceRightKey;
extern NSString* const CRItemsAtPlainSpaceBottomKey;
extern NSString* const CRItemsAtPlainScaleKey;

//////////////////////////////////////////////////////////////////////
// CRPatternOverPathPlain
// This processor applies specified patter over the path and
// produces a bitmap plane with the strokes
//////////////////////////////////////////////////////////////////////
@interface CRItemsAtPlain : CRImageProcessor
{
@private
	NSShadow*			shadow;
	NSBitmapImageRep*	buffer;
}

@property (nonatomic, copy)   NSArray*	items;
@property (nonatomic, assign) BOOL		dropShadows;
@property (nonatomic, assign) NSInteger	layers;
@property (nonatomic, assign) CGFloat	itemsScale;
@property (nonatomic, assign) CGFloat	dispertion;
@property (nonatomic, assign) CGFloat	spaceLeft;
@property (nonatomic, assign) CGFloat	spaceTop;
@property (nonatomic, assign) CGFloat	spaceRight;
@property (nonatomic, assign) CGFloat	spaceBottom;
@property (nonatomic, assign) CGFloat	scale;			// mip-map scale value

@end