//
//  CROnViewEditorPath.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/4/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRInplaceEditor.h"
#import "CRPathHolder.h"

extern NSString* const CRPathEditorModeOverlay;
extern NSString* const CRPathEditorModeExternalColor;
extern NSString* const CRPathEditorModeInternalColor;

//////////////////////////////////////////////////////////////////////
// On-View editor class for vector paths
//////////////////////////////////////////////////////////////////////
@interface CRInplaceEditorPath : CRInplaceEditor
{
	CGFloat					dotRadius;
	BOOL					drawHelp;
	CRPathHolder*			pathHolder;
	CRPathRenderingMode		renderingMode;
	
	CRPointAction			action;
	NSMutableArray*			workingPath;
	NSMutableDictionary*	modeAttributes;
}

@property (nonatomic, assign)	BOOL					drawHelp;
@property (nonatomic, strong)	CRPathHolder*			pathHolder;
@property (nonatomic, assign)	CGFloat					dotRadius;
@property (nonatomic, readonly) NSMutableDictionary*	modeAttributes;

- (BOOL)shouldDrawPathPoint:(NSUInteger)index;

@end