//
//  CRInplaceEditorMaskToolsController.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 1/22/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRInplaceEditorToolsController.h"

@class CRInplaceEditorController;

//////////////////////////////////////////////////////////////////////
// Inplace mask editor tools controller
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRMaskActionFill,
	CRMaskActionClear,
	CRMaskActionCopy,
	CRMaskActionPaste,
} CRMaskQuickAction;

@interface CRInplaceEditorMaskToolsController : CRInplaceEditorToolsController
{
}

// Outlets
@property (nonatomic, assign) IBOutlet NSSegmentedControl*	toolsButton;
@property (nonatomic, assign) IBOutlet NSButton*			quickActionsButton;

- (id)initWithEditorController:(CRInplaceEditorController *)aController;

// Actions
- (IBAction)fillMask:(id)sender;
- (IBAction)clearMask:(id)sender;
- (IBAction)copyMask:(id)sender;
- (IBAction)pasteMask:(id)sender;
- (IBAction)loadMask:(id)sender;
- (IBAction)saveMask:(id)sender;
- (IBAction)quickAction:(id)senderButton;

@end