//
//  CRInplaceEditorController.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/11/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRInplaceEditor.h"
#import "CRInplaceEditorToolsController.h"

//////////////////////////////////////////////////////////////////////
// Basic On-View editor controller
//////////////////////////////////////////////////////////////////////
@interface CRInplaceEditorController : NSViewController
{
	CRScene* assigned root;
	
@protected
	CRInplaceEditor* editor;
	CRInplaceEditorToolsController* toolsController;
}

@property (nonatomic, assign)	CRScene* root;
@property (nonatomic, readonly) CRInplaceEditor* editor;
@property (nonatomic, readonly) CRInplaceEditorToolsController* toolsController;

- (id)initWithEditorClass:(Class)aClass;
- (void)finalizeEdit;
- (void)prepare;
- (void)connect;
- (void)disconnect;
- (void)updateAreas;

- (IBAction)setDefaults:(id)sender;

@end