//
//  CRImagesBatchProcessor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/10/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRBatchProcessor.h"
#import "CRImageFormat.h"

@class CRPreset;

//////////////////////////////////////////////////////////////////////
// Image batch processing delegate
//////////////////////////////////////////////////////////////////////
@interface CRImagesBatchProcessor : NSObject<CRBatchProcessingDelegate>
{
	NSUInteger		totalUnits;
	
@protected
	NSDictionary*	savingOptions;
}

@property (nonatomic, assign) CRPreset*				preset;
@property (nonatomic, assign) id<CRImageComposer>	composer;
@property (nonatomic, strong) NSArray*				allFormats;
@property (nonatomic, strong) CRImageFormat*		outputFormat;
@property (nonatomic, assign) NSInteger				selectedFormatIndex;

// Outlets
@property (nonatomic, assign) IBOutlet NSWindow*				mainWindow;
@property (nonatomic, assign) IBOutlet NSWindow*				progressSheet;
@property (nonatomic, assign) IBOutlet NSTextField*				labelProgressStatus;
@property (nonatomic, assign) IBOutlet NSProgressIndicator*		indicatorProgress;

@end