//
//  CRImageProcessor].h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/4/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRSceneItemBase.h"

extern NSString* const CRImageProcessorInputImageKey;
extern NSString* const CRImageProcessorOutputImageKey;
extern NSString* const CRImageProcessorTransformedImageKey;

//////////////////////////////////////////////////////////////////////
// Render lock
//////////////////////////////////////////////////////////////////////
class CRRenderLock
{
	BOOL& b;
public:
	inline CRRenderLock(BOOL& ref)
		: b(ref)
	{
		b = YES;
	}
	
	inline ~CRRenderLock()
	{
		b = NO;
	}
};

//////////////////////////////////////////////////////////////////////
// Base image processor
//////////////////////////////////////////////////////////////////////
@interface CRImageProcessor : CRSceneItemBase
{
@protected
	BOOL				isRendering;
	CIImage*			outputImage;
	CIImage*			transformedImage;
	CRMultiDelegate*	onDirty;
	CRMultiDelegate*	onApplied;
	
	BOOL				isDirty;
}

@property (nonatomic, copy)		CIImage*			inputImage;
@property (nonatomic, readonly) CIImage*			outputImage;
@property (nonatomic, readonly) CIImage*			transformedImage;
@property (nonatomic, readonly) CRMultiDelegate*	onDirty;
@property (nonatomic, readonly) CRMultiDelegate*	onApplied;

// Init
- (id)init;
- (id)initNoDeferred;
- (id)initClean;

// Flags
- (BOOL)isGenerator;			// signals whether the filter generates outputImage without input (i.e. is generator)
- (BOOL)dependsOnSceneParams;	// signals whether the filter depends on root Scene input parameters (other than inputImage)
- (BOOL)scaleable;				// signals whether the filter requires scaling data for optimization
- (BOOL)supportsMask;			// signals whether the filter supports masking

// Processing
- (BOOL)isRendering;
- (BOOL)isDirty;
- (void)markDirty;
- (CIImage *)applyProcessor:(BOOL)transformOnly;

@end