//
//  CRImageFilterTextured.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 10/25/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

#import "CRCIImageFilter.h"
#import "CRMaterialTexture.h"
#import "CRTextureAdapter.h"

extern NSString* const CRImageFilterTexturedMaterialKey;
extern NSString* const CRImageFilterTexturedTextureAdapterKey;

//////////////////////////////////////////////////////////////////////
// Base filter for texture-based filters, declares a single texture
// and texture processor (adapter)
//////////////////////////////////////////////////////////////////////
@interface CRImageFilterTextured : CRCIImageFilter
{
@protected
	CRMaterialTexture*	material;
	CRTextureAdapter*	textureAdapter;
}

@property (nonatomic, strong) CRMaterialTexture*	material;
@property (nonatomic, strong) CRTextureAdapter*		textureAdapter;

@end