//
//  CRGraphicsMarker.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 10/14/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRGraphicsObject.h"

//////////////////////////////////////////////////////////////////////
// Marker represents a Point of the object space in the window space.
// However, it accepts a Rect (filterRect property) ignoring the size
// to unify the architecture with other graphics objects
//////////////////////////////////////////////////////////////////////
@interface CRGraphicsMarker : CRGraphicsObject
{
	NSPoint offset;
	NSSize	size;
}

@property (nonatomic, assign) NSPoint	offset;	// marker offset in view space
@property (nonatomic, assign) NSSize	size;	// marker size in view space

- (id)initWithFrame:(NSRect)frameRect;
- (id)initWithFrame:(NSRect)frameRect style:(CRGraphicsObjectStyle)style;

@end