//
//  CRGraphicsDraggableView.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/4/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRGraphicsObjectBase;

//////////////////////////////////////////////////////////////////////
// Draggable view
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRSelectModeNone = 0,
	CRSelectModeOnOff,
	CRSelectModeToggle,
} CRGraphicsObjectSelectMode;

@interface CRGraphicsDraggableView : NSView
{
	BOOL	selected;
	BOOL	isMouseDown;
	BOOL	isDragging;
	
	BOOL	undoGrouped;
	NSPoint	dragOrigin;
	NSPoint frameOrigin;
}

@property (nonatomic, assign)	BOOL isDraggable;
@property (nonatomic, readonly) BOOL isDragging;
@property (nonatomic, assign)	BOOL groupUndoOnDrag;
@property (nonatomic, assign, getter = isSelected)	BOOL selected;

@property (nonatomic, assign)	CRGraphicsObjectSelectMode selectionMode;

- (NSArray *)chainedObjects;
- (CRGraphicsObjectBase *)holder;
- (NSImageInterpolation)imageInterpolation;
- (BOOL)antialiasing;

- (NSRect)accurateBounds;
- (NSArray *)images;

- (BOOL)shiftIsPressed;

@end