//
//  CRGraphics.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/22/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

// Constants
#import "CRGConstants.h"

// Protocols
#import "CRGProtocols.h"

// Settings
#import "CRSettings.h"

// Transformers
#import "CIImageToNSImageTransformer.h"

// Categories
#import "CIImage+CRGraphics.h"
#import "NSImage+CRGraphics.h"
#import "CRCommonDraw+CoreImage.h"
#import "CIImageAccumulator+CRGraphics.h"

// Math
#import "Math3D.h"
#import "Curves.h"

// General
#import "CRSharedRenderer.h"

// CoreImage filters
#import "CRCIMaskOutCompositing.h"
#import "CRCILineClip.h"
#import "CRCIGaussianBlurAdaptive.h"
#import "CRCIPushThrough.h"
#import "CRCISoftLomoGradient.h"
#import "CRCISphereSpot.h"
#import "CRCISphereDiffuse.h"
#import "CRCIBumpLight.h"
#import "CRCITile.h"

#import "CRCICut.h"
#import "CRCIHistogramFix.h"
#import "CRCIOpacity.h"
#import "CRCIValueClamp.h"
#import "CRCIChannelContrast.h"
#import "CRCIHSLCorrection.h"
#import "CRCILevels.h"
#import "CRCILomo.h"
#import "CRCIVignette.h"
#import "CRCISingleChannel.h"
#import "CRCIComposeAddAccurate.h"
#import "CRCILinearLightBlendMode.h"
#import "CRCISoftLightBlendMode.h"
#import "CRCIMaskMixer.h"
#import "CRCISourceOverCompositing.h"
#import "CRCINoise.h"
#import "CRCIVignetteGradient.h"
#import "CRCILinearCompositing.h"
#import "CRColorModulate.h"
#import "CRCICurve.h"
#import "CRCIDynamicLight.h"
#import "CRCITreshold.h"
#import "CRCIFishEye.h"
#import "CRCIBlackWhite.h"
#import "CRCILuminanceEdges.h"
#import "CRCILinearBurnBlendMode.h"
#import "CRCIVividLightBlendMode.h"
#import "CRCISmartBlur.h"

// Generators (backgrounds)
#import "CRBackgroundProvider.h"
#import "CRBackgroundProviderColor.h"
#import "CRBackgroundProviderCheckerboard.h"
#import "CRBackgroundProviderRadialGradient.h"
#import "CRBackgroundProviderTexture.h"

// Processors
#import "CRImageProcessor.h"
#import "CRImageScaler.h"
#import "CRMultiComposer.h"
#import "CRTextureOriginNormalizer.h"
#import "CRTextureAdapter.h"
#import "CRFrameAdapter.h"
#import "CRBorderAdapter.h"

// Graphics: Path
#import "CRPathHolder.h"
#import "CRPatternOverPath.h"
#import "CRPatternOverPathStrokes.h"
#import "CRPatternOverPathPlain.h"
#import "CRPathClipGenerator.h"

// Graphics auxilliary classes
#import "CRSceneItemPortsAuxiliary.h"
#import "CRImageScaler.h"
#import "CRMipMapper.h"
#import "CRShadowGenerator.h"
#import "CRShadowMixer.h"
#import "CRItemsAtPlain.h"
#import "CRMultiComposer.h"
#import "CRShaderMaterial.h"
#import "CRShaderBump.h"
#import "CRCIHistogram.h"
#import "CRCICanvas.h"

// Scene
#import "CRImageData.h"
#import "CRLayer.h"
#import "CRPreset.h"
#import "CRScene.h"
#import "CRSceneItemBase.h"
#import "CRSceneItemVisual.h"
#import "CRSceneItemQuartzComposition.h"

// Scene: Auxilliary
#import "CRSceneItemShadowGenerator.h"

// Textures
#import "CRTexture.h"
#import "CRTextureCorrectionViewController.h"

// Processors
#import "CRCIImageFilter.h"
#import "CRImageFilterTextured.h"
#import "CRImageFilterBlender.h"
#import "CRImageFilterCrop.h"
#import "CRImageFilterCaption.h"
#import "CRImageFilterSprite.h"
#import "CRImageFilterResize.h"
#import "CRImageFilterCurves.h"
#import "CRViewControllerTexture.h"

// Materials
#import "CRMaterial.h"
#import "CRMaterialColor.h"
#import "CRMaterialTexture.h"
#import "CRMaterialGradient.h"
#import "CRMaterialPath.h"
#import "CRMaterialShader.h"
#import "CRMaterialSphere.h"
#import "CRMaterialRandom.h"
#import "CRMaterialBump.h"

// Frames
#import "CRFramer.h"
#import "CRFramerFill.h"
#import "CRFramerImage.h"
#import "CRFramerBorder.h"
#import "CRFramerPath.h"
#import "CRFramerField.h"

// Controls: Inplace
#import "CRInplaceEditorDescriptor.h"
#import "CRInplaceEditor.h"
#import "CRInplaceEditorController.h"
#import "CRInplaceEditorToolsController.h"

#import "CRInplaceEditorPath.h"
#import "CRInplaceEditorPathController.h"

#import "CRInplaceEditorMask.h"
#import "CRInplaceEditorMaskController.h"
#import "CRInplaceEditorMaskToolsController.h"

// Control: Object
#import "CRGraphicsDraggableView.h"
#import "CRGraphicsObjectControlPoint.h"
#import "CRGraphicsObjectRotator.h"
#import "CRGraphicsObject.h"
#import "CRGraphicsMarker.h"
#import "CRGraphicsMarkerRotatable.h"

// Controls & Controllers
#import "CRImageWell.h"
#import "CRGradientEditor.h"
#import "CRPhotoPlaceholder.h"

#import "CRBackedScrollView.h"
#import "CRPhotoView.h"
#import "CRPhotoViewController.h"

#import "CRPhotoNavigatorView.h"
#import "CRPhotoNavigatorViewController.h"
#import "CRPhotoViewScrollable.h"
#import "CRPhotoViewScrollableController.h"

// Library
#import "CRPresetsLibraryManager.h"
#import "CRPresetsLibraryController.h"
#import "CRPresetsWindowController.h"
#import "CRPresetsCollectionView.h"
#import "CRPresetsCollectionItem.h"
#import "CRPresetsCollectionItemView.h"

#import "CRTexturesLibraryManager.h"
#import "CRTexturesLibraryController.h"
#import "CRTexturesLibraryViewController.h"

// Batch
#import "CRImageFormat.h"
#import "CRBatchProcessor.h"
#import "CRBatchProcessingItem.h"
#import "CRImagesBatchProcessor.h"
#import "CRBatchCollectionItem.h"
#import "CRBatchProcessorWindowController.h"

// Registration
void CRGraphicsInitialize();
void CRGraphicsCleanup();