//
//  CRGProtocols.h
//  CRGraphocs
//
//  Created by Yaroslav Glushchenko on 12/22/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRScene;

//////////////////////////////////////////////////////////////////////
// Any model object that provides an in-plance editor
//////////////////////////////////////////////////////////////////////
@protocol CRInplaceEditing

- (NSUInteger)defaultEditor;
- (NSArray *)inplaceEditors;

@end

//////////////////////////////////////////////////////////////////////
// CRFrameGenerator
//////////////////////////////////////////////////////////////////////
@protocol CRFrameGenerator

@property (nonatomic, assign) NSRect frameRect; // relative frame rect in [0, 1] space of the input

- (NSRect)constraintRect:(NSRect)rect;

@end

//////////////////////////////////////////////////////////////////////
// CRPhotoView image source
//////////////////////////////////////////////////////////////////////
@protocol CRPhotoViewImageSourceProtocol

- (CRScene *)source;
- (CIImage *)imageToRender;

- (BOOL)autozoom;
- (CGFloat)zoom;
- (void)setZoom:(CGFloat)newZoom;

- (BOOL)updatingWithNewFrame:(NSRect)newFrame oldFrame:(NSRect)oldFrame;

@end

//////////////////////////////////////////////////////////////////////
// CREmbeddedResourcesContainer
//////////////////////////////////////////////////////////////////////
@protocol CREmbeddedResourcesContainer

- (BOOL)containsDataForKeyPath:(NSString *)keyPath;
- (id)dataForKeyPath:(NSString *)keyPath;
- (void)setData:(id)data forKeyPath:(NSString *)keyPath;

@end

//////////////////////////////////////////////////////////////////////
// Image Composer
//////////////////////////////////////////////////////////////////////
@protocol CRImageComposer

- (NSBitmapImageRep *)composeImage:(CIImage *)image;
- (NSBitmapImageRep *)composeImage:(CIImage *)image colorSpace:(NSString *)colorSpaceName;

@end