//
//  CRFramerPath.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/31/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRFramer.h"

@class CRPathHolder;
@class CRPatternOverPath;
@class CRPathClipGenerator;

extern NSString* const CRFramerPathDoClipKey;
extern NSString* const CRFramerPathCompositeOperationKey;
extern NSString* const CRFramerPathModeKey;

//////////////////////////////////////////////////////////////////////
// Border frame generator. Uses material texture as a brush pattern
// and applies it over the path
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRFramerPathNoProcessingMode = 0,
	CRFramerPathStrokesProcessingMode,
	CRFramerPathPathProcessingMode,
} CRFramerPathMode;

@interface CRFramerPath : CRFramer
{
	NSArray*				availableCompositeOperations;	// available strokes composers
	
	CRPathHolder*			pathHolder;						// path holder. create manually to be used with both PathClip & PathFiller
	CRPathClipGenerator*	pathClipGenerator;				// path clip mask generator
	CRPatternOverPath*		pathFiller;						// path strokes generator
}

@property (nonatomic, assign)	BOOL				doClip;							// flags signals whether we need out-of-path clip
@property (nonatomic, strong)	CRPathHolder*		pathHolder;
@property (nonatomic, readonly)	CRPatternOverPath*	pathFiller;
@property (nonatomic, readonly)	NSArray*			availableCompositeOperations;
@property (nonatomic, assign)	NSUInteger			selectedCompositeOperation;		// selected strokes composer
@property (nonatomic, assign)	CRFramerPathMode	pathMode;

- (NSSize)safeInset;

@end