//
//  CRFramerBackground.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/14/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRFramer.h"

extern NSString* const CRFramerBackgroundSymmetricFrameKey;
extern NSString* const CRFramerBackgroundRelativeKey;
extern NSString* const CRFramerBackgroundSpaceLeftKey;			// this port must be defined by the subclass!
extern NSString* const CRFramerBackgroundSpaceTopKey;			// this port must be defined by the subclass!
extern NSString* const CRFramerBackgroundSpaceRightKey;			// this port must be defined by the subclass!
extern NSString* const CRFramerBackgroundSpaceBottomKey;		// this port must be defined by the subclass!

//////////////////////////////////////////////////////////////////////
// ABSTRACT:
// Background generator number defines of ports for spacing-based
// framers like CRFramerFill and CRFramerField
//////////////////////////////////////////////////////////////////////
@interface CRFramerBackground : CRFramer
{
}

@property (nonatomic, assign) BOOL symmetricFrame;

- (void)fetchDependedSpaces; // used with "symmetricFrame"

@end