//
//  CRFrameAdapter.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/6/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

extern NSString* const CRFrameAdapterDoTileKey;
extern NSString* const CRFrameAdapterRelativeCoordKey;
extern NSString* const CRFrameAdapterAutoImageKey;
extern NSString* const CRFrameAdapterSpaceLeftKey;
extern NSString* const CRFrameAdapterSpaceTopKey;
extern NSString* const CRFrameAdapterSpaceRightKey;
extern NSString* const CRFrameAdapterSpaceBottomKey;

//////////////////////////////////////////////////////////////////////
// Similar to CRTextureAdapter, but is intended to be used for frames
// and backgrounds: it has no direct rect, no rotation, auto-adjusts
// crop
// 
// COMMENT:
// NSCoding support does not encode images!
//////////////////////////////////////////////////////////////////////
@interface CRFrameAdapter : CRImageProcessor
{
}

@property (nonatomic, assign) BOOL		doTile;			// signals whether output texture should be tiled
@property (nonatomic, assign) BOOL		relativeCoord;	// signals whether space coordinates should be treat as relative (% of the autoImage)
@property (nonatomic, assign) CIImage*	autoImage;		// adapter will adjust all params with this image: origin, size, crop etc.

@property (nonatomic, assign) CGFloat	spaceLeft;
@property (nonatomic, assign) CGFloat	spaceTop;
@property (nonatomic, assign) CGFloat	spaceRight;
@property (nonatomic, assign) CGFloat	spaceBottom;

- (CGRect)innerRectForFrameRect:(CGRect)frameRect;

@end