//
//  CRCompositeOperation.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/31/10.
//  Copyright 2010 Corner-A. All rights reserved.
//


//////////////////////////////////////////////////////////////////////
// Composite image operation
//////////////////////////////////////////////////////////////////////
@interface CRCompositeOperation : NSObject
{
	NSString* filterName;
	NSString* operationName;
	NSString* shortDescription;
}

@property (readonly) NSString* filterName;
@property (readonly) NSString* operationName;
@property (readonly) NSString* shortDescription;

- (id)initWithFilterName:(NSString*)filter operationName:(NSString*)operation description:(NSString*)shortDesc;
+ (id)descriptorWithFilterName:(NSString*)filter operationName:(NSString*)operation description:(NSString*)shortDesc;

+ (NSArray*)availableOperations;

@end
